/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.moulberry.axiom.Axiom;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_310;

public class Authorization {
    private static final String PUBKEY = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAvvwXcWKKx5ee1lrpIsVF\n5lRNBpB+0Krlc8HNcahvTRu7IOF9mz68ATSqf94lJbvU0jVPg1I4bvAAuniDTRI2\n28WeoQpNPM6iSdcIc7hLbThDX9iWYqne+YBve0NwGkFpxHZTrwFSRmIixg/0nTQZ\nS00xhCGynVJgOMbMVUaD4v/5Tsj9s0KxSss2mZLMpMCUEMrB3P6AGQ8abr6hPJXM\nk8v5+BbfTljpv8GX6OQIWKmktNMWca0Zj69Ixf1llog9bgTxn4LyCR1zWnGYxaj3\nqe8N/MY9zKNamV6eL+JNTnlXSauLnwBjENGG6nZuPzRTPbw/VhH+gBvgZFhiOUUu\ndfkOhDltnP7viJKAM3mtvU6GpntzeWuoji2FnsXKmj7qkCi8lWEl6Ah5l0YVxm75\nC+7Uz4gndd4sJGpuzH8w798ifWiknaIfgP5qvwmUdcIrotZc67WXE1Apmgvn+oNO\nmru3HZJg14oto0FYyVfVMzvNjKcn4P3vD6MkxlecqsMCVKlkZ5MaM7NeSv+q1q/f\ns072mHPiXxc/cr7C/1ZdlGcEv44L8yQTJf1glS8fzKNNrQaFvonJPMb0VMO8rP+N\nPrjTmUMlSjzDwDQAu3bzFUWnWwsL3T5CgNdnNcNpyU4XxtIUNbOcMD1FeI49breb\nPnT3DkeYK/iYneS6JW2pqiECAwEAAQ==\n";

    public static String getUserAgent() {
        ModContainer axiomMod = (ModContainer)FabricLoader.getInstance().getModContainer("axiom").get();
        return "Axiom/" + axiomMod.getMetadata().getVersion().getFriendlyString();
    }

    public static CompletableFuture<Meta> getMeta() {
        CompletableFuture<Meta> future = new CompletableFuture<Meta>();
        ForkJoinPool.commonPool().submit(() -> {
            try {
                URL url = new URL("https://axiom.moulberry.com/api/mcauth/meta");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", Authorization.getUserAgent());
                conn.setConnectTimeout(5000);
                conn.setRequestMethod("GET");
                InputStream inputStream = conn.getInputStream();
                String input = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                conn.disconnect();
                Gson gson = new GsonBuilder().create();
                JsonObject jsonObject = (JsonObject)gson.fromJson(input, JsonObject.class);
                String latestModVersion = null;
                JsonElement patt0$temp = jsonObject.get("latest_mod_version");
                if (patt0$temp instanceof JsonPrimitive) {
                    JsonPrimitive jsonPrimitive = (JsonPrimitive)patt0$temp;
                    latestModVersion = jsonPrimitive.getAsString();
                }
                String modDisabled = null;
                JsonElement patt1$temp = jsonObject.get("mod_disabled");
                if (patt1$temp instanceof JsonPrimitive) {
                    JsonPrimitive jsonPrimitive = (JsonPrimitive)patt1$temp;
                    modDisabled = jsonPrimitive.getAsString();
                }
                ArrayList<String> latestChangelog = null;
                JsonElement patt2$temp = jsonObject.get("latest_changelog");
                if (patt2$temp instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)patt2$temp;
                    latestChangelog = new ArrayList<String>();
                    for (JsonElement jsonElement : jsonArray) {
                        latestChangelog.add(jsonElement.getAsString());
                    }
                }
                future.complete(new Meta(latestModVersion, latestChangelog, modDisabled));
            }
            catch (Exception e) {
                e.printStackTrace();
                future.complete(null);
            }
        });
        return future;
    }

    public static CompletableFuture<Boolean> checkCommercial() {
        RSAPublicKey publicKey;
        try {
            byte[] bytes = Base64.getDecoder().decode(PUBKEY.replace("\n", ""));
            X509EncodedKeySpec ks = new X509EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            publicKey = (RSAPublicKey)kf.generatePublic(ks);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(false);
        }
        UUID uuid = class_310.method_1551().method_1548().method_44717();
        if (uuid == null) {
            return CompletableFuture.completedFuture(false);
        }
        Algorithm algorithm = Algorithm.RSA256(publicKey);
        JWTVerifier verifier = JWT.require(algorithm).withSubject(uuid.toString()).acceptNotBefore(86400L).acceptExpiresAt(86400L).ignoreIssuedAt().build();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ForkJoinPool.commonPool().submit(() -> {
            try {
                Path path = Axiom.getInstance().getConfigDirectory().resolve(".license");
                try {
                    URL url = new URL("https://axiom.moulberry.com/api/mcauth/has_commercial_license?uuid=" + String.valueOf(uuid));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", Authorization.getUserAgent());
                    conn.setConnectTimeout(5000);
                    conn.setRequestMethod("GET");
                    if (conn.getResponseCode() == 401) {
                        if (Files.exists(path, new LinkOption[0])) {
                            Files.delete(path);
                        }
                        future.complete(false);
                        return;
                    }
                    if (conn.getResponseCode() != 200) {
                        future.complete(false);
                        return;
                    }
                    String jwt = new String(conn.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                    try {
                        verifier.verify(jwt);
                        Files.writeString(path, (CharSequence)jwt, StandardCharsets.UTF_8, new OpenOption[0]);
                        future.complete(true);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Files.exists(path, new LinkOption[0])) {
                    try {
                        String jwt = Files.readString(path, StandardCharsets.UTF_8);
                        verifier.verify(jwt);
                        future.complete(true);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                future.complete(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return future;
    }

    public static CompletableFuture<ServerAuthorization> checkServer(String server, String host) {
        RSAPublicKey publicKey;
        try {
            byte[] bytes = Base64.getDecoder().decode(PUBKEY.replace("\n", ""));
            X509EncodedKeySpec ks = new X509EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            publicKey = (RSAPublicKey)kf.generatePublic(ks);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(ServerAuthorization.NO);
        }
        UUID uuid = class_310.method_1551().method_1548().method_44717();
        if (uuid == null) {
            return CompletableFuture.completedFuture(ServerAuthorization.NO);
        }
        Algorithm algorithm = Algorithm.RSA256(publicKey);
        JWTVerifier verifier = JWT.require(algorithm).withSubject(String.valueOf(uuid) + "/" + server).acceptNotBefore(86400L).acceptExpiresAt(86400L).ignoreIssuedAt().build();
        CompletableFuture<ServerAuthorization> future = new CompletableFuture<ServerAuthorization>();
        ForkJoinPool.commonPool().submit(() -> {
            try {
                URL url = new URL("https://axiom.moulberry.com/api/mcauth/connect?uuid=" + String.valueOf(uuid) + "&server=" + server + "&host=" + host);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", Authorization.getUserAgent());
                conn.setConnectTimeout(5000);
                conn.setRequestMethod("GET");
                if (conn.getResponseCode() == 401) {
                    future.complete(ServerAuthorization.NO);
                    return;
                }
                if (conn.getResponseCode() != 200) {
                    future.complete(ServerAuthorization.NO);
                    return;
                }
                String jwt = new String(conn.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                DecodedJWT decoded = verifier.verify(jwt);
                Claim commercialClaim = decoded.getClaim("commercial");
                if (commercialClaim != null && Boolean.TRUE.equals(commercialClaim.asBoolean())) {
                    future.complete(ServerAuthorization.COMMERCIAL);
                } else {
                    future.complete(ServerAuthorization.YES);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                future.complete(ServerAuthorization.NO);
            }
        });
        return future;
    }

    public static enum ServerAuthorization {
        YES,
        NO,
        COMMERCIAL;

    }

    public record Meta(String latestModVersion, List<String> latestChangelog, String modDisabled) {
    }
}

